(
	-- Standard Material (Approximation)

    struct AMGData
	(
		fn GetUUID mtl context = 
		(
			"480295f3-8b79-4622-b7ef-84e86073d73c"
		)
		,
		fn GetMaps mtl context = 
		(
			local res = #()	

			if mtl.diffuseMap != undefined and mtl.diffuseMapEnable do (
				append res #("diffuseMap",      mtl.diffuseMap)
				append res #("diffuseMapAlpha", mtl.diffuseMap, "alpha")
			)

			-- some subshaders have this, others don't. We used it when it's there....
			if hasProperty mtl "diffuseLevelMap" do
			(
				if mtl.diffuseLevelMap != undefined and mtl.diffuseLevelMapEnable do 
					append res #("diffuseLevelMap", mtl.diffuseLevelMap, "resultFloat")
			)

			if mtl.opacityMap != undefined and mtl.opacityMapEnable do (
				append res #("opacityMap",      mtl.opacityMap, "resultFloat")
			)

			if mtl.bumpMap != undefined and mtl.bumpMapEnable do (
				append res #("bump",            mtl.bumpMap,    "normalPerturb", 1)
			)

			-- some subshaders have this, others don't. We used it when it's there....
			if hasProperty mtl "Specular" do
			(
				if mtl.specularMap != undefined and mtl.specularMapEnable do (
					append res #("specularMap",      mtl.specularMap)
				)
				if mtl.specularLevelMap != undefined and mtl.specularLevelMapEnable do (
					append res #("specularLevelMap", mtl.specularLevelMap, "resultFloat")
				)
				if mtl.glossinessMap != undefined and mtl.glossinessMapEnable do (
					append res #("glossinessMap",    mtl.glossinessMap,    "resultFloat")
				)
			)


			if hasProperty mtl "selfillumMap" do
			(
				if mtl.selfIllumMap != undefined and mtl.selfillumMapEnable do (
					append res #("selfIllumMap",      mtl.selfillumMap)
				)
			)

			res
		),

		fn GetParams mtl context =
		(
			local res = #()	

			-- Diffuse
			append res #("diffuse",           mtl.diffuse)

			-- Diffuse map knobs
			append res #("diffuseMapAmount",  mtl.diffuseMapAmount / 100.0)
			append res #("diffuseMapAlpha",   0.0) 

			-- some subshaders have this, others don't. We used it when it's there....
			if (hasProperty mtl "diffuseLevel") then (
				append res #("diffuseLevel",      mtl.diffuseLevel / 100.0)
			)
			else
			(
				append res #("diffuseLevel",      1.0)
			)

			-- some subshaders have this, others don't. We used it when it's there....
			if (hasProperty mtl "diffuseLevelMap") then (
				if mtl.diffuseLevelMap != undefined and mtl.diffuseLevelMapEnable then (
					append res #("diffuseLevelMapAmount",      mtl.diffuseLevelMapAmount / 100.0)
				)
				else
				(
					append res #("diffuseLevelMapAmount",      0.0)
				)
			)
			else
			(
				append res #("diffuseLevelMapAmount",      0.0)
			)


			-- some subshaders have this, others don't. We used it when it's there....
			if hasProperty mtl "Specular" then
			(
				append res #("specular",      mtl.specular)

				if mtl.specularMap != undefined and mtl.specularMapEnable then (
					append res #("specularMapAmount",      mtl.specularMapAmount / 100.0)
				)
				else
				(
					append res #("specularMapAmount",      0.0)
				)

				append res #("specularLevel",  mtl.specularLevel  / 100.0)

				if mtl.specularLevelMap != undefined and mtl.specularLevelMapEnable then (
					append res #("specularLevelMapAmount", mtl.specularLevelMapAmount / 100.0)
				)
				else
				(
					append res #("specularLevelMapAmount", 0.0)
				)

				append res #("glossiness",  mtl.glossiness  / 100.0)

				if mtl.glossinessMap != undefined and mtl.glossinessMapEnable then (
					append res #("glossinessMapAmount", mtl.glossinessMapAmount / 100.0)
				)
				else
				(
					append res #("glossinessMapAmount", 0.0)
				)
			)
			else
			(
				-- No speculars
				append res #("specularLevel", 0.0)				
			)

			local emissive = false

			if hasProperty mtl "selfillumAmount" then
			(
				if mtl.selfIllumMap != undefined and mtl.selfillumMapEnable then (
					append res #("selfIllumMapAmount",      mtl.selfillumMapAmount / 100.0)
					emissive = true
				)
				else
				(
					append res #("selfIllumMapAmount",      0.0)
				)

				if mtl.useSelfIllumColor then (
					append res #("selfIllum",   mtl.selfIllumColor)
					emissive = true
				)
				else
				(
					local x = (mtl.selfIllumAmount / 100.0) * 256.0

					if x > 0 do emissive = true

					append res #("selfIllum",   (color x x x))
				)

				append res #("useSelfIllumColor", mtl.useSelfIllumColor)
			)
			else
			(
				append res #("selfIllum",           (color 0 0 0))
				append res #("selfIllumMapAmount",  0.0)
				append res #("useSelfIllumColor",   false)
			)

			-- Flag emissive or not

			append res #("att:emissive", emissive) 

			-- Opacity
			append res #("opacity",           mtl.opacity / 100.0)
			append res #("opacityMap",        mtl.opacity / 100.0)

			-- Opacity map knobs
			if mtl.opacityMap != undefined and mtl.opacityMapEnable then 			
				append res #("opacityMapAmount",  mtl.opacityMapAmount / 100.0)
			else
				append res #("opacityMapAmount",  0.0)
			
			-- Bump map knobs
			append res #("bumpAmount",  mtl.bumpMapAmount / 100.0)

			res
		)
	)

	AMGData()	
)
